<?php

class gs
{
    private $cred;
    private $token;

    public $error;

    public function __construct($file_name)
    {
        $this -> connect($file_name);
    }

    private function connect($file_name)
    {
        try
        {
            $path = __DIR__ . '/gs/' . $file_name . '.json';
            if (!file_exists($path)) { $this -> error = 'Service Account Not Found'; return; }

            $this -> cred = json_decode(file_get_contents($path), true);
            if (!$this -> cred) { $this -> error = 'Service Account Invalid'; return; }

            $this -> token = $this -> get_jwt_token();
            if (!$this -> token) { $this -> error = 'Cannot Get Access Token'; return; }
        }
        catch (Exception $e) { $this -> error = $e -> getMessage(); }
    }

    private function get_jwt_token()
    {
        $header  = base64_encode(json_encode(['alg' => 'RS256', 'typ' => 'JWT']));
        $now     = time();
        $claim   = [
            'iss'   => $this -> cred['client_email'],
            'scope' => 'https://www.googleapis.com/auth/spreadsheets',
            'aud'   => 'https://oauth2.googleapis.com/token',
            'iat'   => $now,
            'exp'   => $now + 3600
        ];
        $payload = base64_encode(json_encode($claim));

        $input = $header . '.' . $payload;

        openssl_sign($input, $signature, $this -> cred['private_key'], 'SHA256');
        $jwt = $input . '.' . base64_encode($signature);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
            'assertion'  => $jwt
        ]));

        $resp = curl_exec($ch);
        curl_close($ch);

        $json = json_decode($resp, true);
        return $json['access_token'] ?? null;
    }

    public function add_rows($sheet_id, $tab_name, $rows)
    {
        if ($this -> error) return ['success' => false, 'error' => $this -> error];
        if (!$this -> token) return ['success' => false, 'error' => 'No Access Token'];

        $url = "https://sheets.googleapis.com/v4/spreadsheets/$sheet_id/values/" . urlencode($tab_name) . ":append?valueInputOption=RAW";

        $data = [ 'values' => $rows ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $this -> token,
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $resp = curl_exec($ch);
        curl_close($ch);

        $json = json_decode($resp, true);

        if (isset($json['updates'])) return array('success' => true);
        return ['success' => false, 'error' => $resp];
    }
}

?>
