<?php

class Admin_Mveb
{
    public static function get_data($content)
    {
        $lines = array_filter(array_map('trim', preg_split('/\r\n|\r|\n/', $content)));

        $data = array();
        foreach ($lines as $line)
        {
            $args = array_filter(array_map('trim', preg_split('/[:;,\|]/', $line)));
            if (count($args) < 2) continue;

            $domain = trim($args[0]);
            $ip = trim($args[1]);

            if ((bool)filter_var($domain, FILTER_VALIDATE_DOMAIN, FILTER_FLAG_HOSTNAME) != true) continue;
            if ((bool)(bool)filter_var($ip, FILTER_VALIDATE_IP) != true) continue;

            array_push($data, $line);
        }

        return $data;
    }
}

class Admin_Json
{
    public static function get_data($content)
{
    $lines = array_filter(array_map('trim', preg_split('/\r\n|\r|\n/', $content)));

    $data = array();
    foreach ($lines as $line)
    {
        $args = array_filter(array_map('trim', preg_split('/[:;,\|]/', $line)));
        if (count($args) < 2) continue;

        $domain = strtolower(trim($args[0]));
        $ip = trim($args[1]);

        if (!filter_var($domain, FILTER_VALIDATE_DOMAIN, FILTER_FLAG_HOSTNAME)) continue;
        if (!filter_var($ip, FILTER_VALIDATE_IP)) continue;

        $parts = explode('.', $domain);
        $count = count($parts);

    
        $tld2 = implode('.', array_slice($parts, -2));
       
        $tld3 = implode('.', array_slice($parts, -3));

      
        if ($count == 2) { array_push($data, $line); continue; }

    
        if ($count == 3 && preg_match('/^[a-z0-9-]+\.[a-z]{2,3}\.[a-z]{2}$/', $tld3)) {
            array_push($data, $line); continue;
        }

    }

    return $data;
}

    public static function build_rows_for_sheets($tasks)
    {
        if (empty($tasks)) return array();

        $rows = array();

        foreach ($tasks as $t)
        {
            $username   = isset($t['username']) ? trim($t['username']) : '';
            $first_name = isset($t['first_name']) ? trim($t['first_name']) : '';
            $last_name  = isset($t['last_name']) ? trim($t['last_name']) : '';
            $fio        = trim($first_name . ' ' . $last_name);

            if (!empty($username)) $user_ref = $username;
            else if (!empty($fio)) $user_ref = $fio;
            else $user_ref = $t['chat_id'];

            $parts = explode(';', $t['data_output']);
            $parts[] = $user_ref;

            array_push($rows, $parts);
        }

        return $rows;
    }


}



?>